Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.SqlClient

''' <summary>
''' Klasa SurveyDB zapewnia dostp do informacji o ankietach w bazie danych
''' </summary>
Public Class SurveyDB

    ''' <summary>
    ''' Pobiera z bazy zestaw danych z list ankiet
    ''' </summary>
    Public Shared Function GetSurveyList() As DataSet
        Dim dsSurveys As DataSet = New DataSet()
        Try
            Using mConnection As New SqlConnection(Config.ConnectionString)

                Dim mCommand As SqlCommand = New SqlCommand("sprocSurveySelectList", mConnection)
                mCommand.CommandType = CommandType.StoredProcedure
                Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
                myDataAdapter.SelectCommand = mCommand
                myDataAdapter.Fill(dsSurveys)
                mConnection.Close()
                Return dsSurveys
            End Using
        Catch ex As Exception
            'Wywoujc wyraenie "Throw" przekazujemy bd do pliku global.asax, ktry wykorzysta domyln stron obsugi bdw do przetworzenia bdu i wywietlenia uytkownikowi zdefiniowanego przez nas komunikatu o bdzie.
            Throw
        End Try
    End Function


    ''' <summary>
    ''' Pobiera z bazy zestaw danych z pytaniami do ankiety
    ''' </summary>
    Public Shared Function GetQuestionsForSurvey(ByVal id As Integer) As DataSet
        Dim dsQuestions As DataSet = New DataSet()
        Try
            Using mConnection As New SqlConnection(Config.ConnectionString)

                Dim mCommand As SqlCommand = New SqlCommand("sprocQuestionSelectList", mConnection)
                mCommand.CommandType = CommandType.StoredProcedure
                Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
                myDataAdapter.SelectCommand = mCommand
                mCommand.CommandType = CommandType.StoredProcedure
                mCommand.Parameters.AddWithValue("@id", id)
                myDataAdapter.Fill(dsQuestions)
                mConnection.Close()
                Return dsQuestions
            End Using
        Catch ex As Exception
            'Wywoujc wyraenie "Throw" przekazujemy bd do pliku global.asax, ktry wykorzysta domyln stron obsugi bdw do przetworzenia bdu i wywietlenia uytkownikowi zdefiniowanego przez nas komunikatu o bdzie.
            Throw
        End Try
    End Function

    ''' <summary>
    ''' Pobiera z bazy danych kolekcj identyfikatorw pyta ankiety
    ''' </summary>
    Public Shared Function GetQuestionIDsForSurvey(ByVal id As Integer) As Collection
        Try
            'wywoaj funkcj GetQuestionsForSurvey, ktra zwrci zestaw danych... 
            Dim dsQuestions As DataSet = GetQuestionsForSurvey(id)
            'pobierz pierwsz tabel w zestawie danych
            Dim dtQuestions As DataTable = dsQuestions.Tables(0)
            'uzyskaj referencj do obiektu kolekcji
            Dim mQuestionCollection As New Collection
            'przejd kolejno po wierszach z identyfikatorami pyta dodajc je przy tym do kolekcji
            For Each dr As DataRow In dtQuestions.Rows
                mQuestionCollection.Add(dr.Item("ID").ToString())
            Next
            'zwr kolekcj identyfikatorw pyta
            Return mQuestionCollection

        Catch ex As Exception
            'Wywoujc wyraenie "Throw" przekazujemy bd do pliku global.asax, ktry wykorzysta domyln stron obsugi bdw do przetworzenia bdu i wywietlenia uytkownikowi zdefiniowanego przez nas komunikatu o bdzie.
            Throw
        End Try
    End Function

    ''' <summary>
    ''' Pobiera z bazy danych 'biec' ankiet
    ''' </summary>
    Public Shared Function GetCurrentSurvey() As DataSet
        Dim dsSurveys As DataSet = New DataSet()
        Try
            Using mConnection As New SqlConnection(Config.ConnectionString)

                Dim mCommand As SqlCommand = New SqlCommand("sprocSurveySelectSingleItemWhereCurrent", mConnection)
                mCommand.CommandType = CommandType.StoredProcedure
                Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
                myDataAdapter.SelectCommand = mCommand
                myDataAdapter.Fill(dsSurveys)
                mConnection.Close()
                Return dsSurveys
            End Using
        Catch ex As Exception
            'Wywoujc wyraenie "Throw" przekazujemy bd do pliku global.asax, ktry wykorzysta domyln stron obsugi bdw do przetworzenia bdu i wywietlenia uytkownikowi zdefiniowanego przez nas komunikatu o bdzie.
            Throw
        End Try
    End Function

    ''' <summary>
    ''' Zwraca egzemplarz klasy <see cref="Survey" /> przesyajc identyfikator ankiety.
    ''' </summary>
    ''' <param name="id">Identyfikator ankiety.</param>
    Public Shared Function [Get](ByVal id As Integer) As Survey
        Dim mSurvey As Survey = Nothing
        Try
            Using mConnection As New SqlConnection(Config.ConnectionString)

                Dim mCommand As SqlCommand = New SqlCommand("sprocSurveySelectSingleItem", mConnection)

                mCommand.CommandType = CommandType.StoredProcedure

                mCommand.Parameters.AddWithValue("@id", id)

                mConnection.Open()
                Using mDataReader As SqlDataReader = mCommand.ExecuteReader(CommandBehavior.CloseConnection)
                    If mDataReader.Read() Then
                        mSurvey = New Survey()
                        mSurvey.Name = mDataReader.GetString(mDataReader.GetOrdinal("Name"))
                        mSurvey.Description = mDataReader.GetString(mDataReader.GetOrdinal("Description"))
                        If mDataReader.GetString(mDataReader.GetOrdinal("IsCurrentSurvey")) = 1 Then
                            mSurvey.IsCurrentSurvey = True
                        Else
                            mSurvey.IsCurrentSurvey = False
                        End If

                    End If
                        mDataReader.Close()
                End Using
            End Using
        Catch ex As Exception
            'Wywoujc wyraenie "Throw" przekazujemy bd do pliku global.asax, ktry wykorzysta domyln stron obsugi bdw do przetworzenia bdu i wywietlenia uytkownikowi zdefiniowanego przez nas komunikatu o bdzie.
            Throw
        End Try
        'przelij referencj do obiektu klasy Survey z powrotem do metody wywoujcej
        Return mSurvey
    End Function

    ''' <summary>
    ''' Zapisuje ankiet w bazie danych.
    ''' </summary>
    ''' <param name="mSurvey">Egzemplarz klasy <see cref="Survey" />, ktry ma by zapisany w bazie danych.</param>
    Public Shared Function Save(ByVal mSurvey As Survey) As Integer

        Using mConnection As New SqlConnection(Config.ConnectionString)

            Dim mNewSurveyID As Integer
            Dim mCommand As SqlCommand = New SqlCommand("sprocSurveyInsertUpdateItem", mConnection)
            mCommand.CommandType = CommandType.StoredProcedure
            If mSurvey.ID > 0 Then
                mCommand.Parameters.AddWithValue("@id", mSurvey.ID)
            Else
                mCommand.Parameters.AddWithValue("@id", DBNull.Value)
            End If
            mCommand.Parameters.AddWithValue("@name", mSurvey.Name)
            mCommand.Parameters.AddWithValue("@description", mSurvey.Description)
            If mSurvey.IsCurrentSurvey = False Then
                mCommand.Parameters.AddWithValue("@iscurrentsurvey", 0)
            Else
                mCommand.Parameters.AddWithValue("@iscurrentsurvey", 1)
            End If

            mConnection.Open()
            mNewSurveyID = mCommand.ExecuteScalar()
            mConnection.Close()

            Return mNewSurveyID

        End Using
    End Function


    ''' <summary>
    ''' Oznacza okrelon ankiet w bazie danych jako biec.
    ''' </summary>
    ''' <param name="id">Identyfikator rekordu <see cref="Survey" /> w bazie danych.</param>
    Public Shared Sub SaveSurveyAsCurrent(ByVal id As Integer)
        Using mConnection As New SqlConnection(Config.ConnectionString)
            Dim mCommand As SqlCommand = New SqlCommand("sprocSurveySaveSingleItemAsCurrent", mConnection)
            mCommand.CommandType = CommandType.StoredProcedure
            mCommand.Parameters.AddWithValue("@id", id)
            mConnection.Open()
            mCommand.ExecuteNonQuery()
            mConnection.Close()
        End Using
    End Sub


    ''' <summary>
    ''' Usuwa ankiet z bazy danych.
    ''' </summary>
    ''' <param name="id">Identyfikator rekordu <see cref="Survey" /> w bazie danych.</param>
    Public Shared Sub Delete(ByVal id As Integer)
        Using mConnection As New SqlConnection(Config.ConnectionString)
            Dim mCommand As SqlCommand = New SqlCommand("sprocSurveyDeleteSingleItem", mConnection)
            mCommand.CommandType = CommandType.StoredProcedure
            mCommand.Parameters.AddWithValue("@id", id)
            mConnection.Open()
            mCommand.ExecuteNonQuery()
            mConnection.Close()
        End Using
    End Sub


    ''' <summary>
    ''' Usuwa pytanie z bazy danych.
    ''' </summary>
    ''' <param name="id">Identyfikator rekordu <see cref="Survey" /> w bazie danych.</param>
    Public Shared Sub DeleteQuestion(ByVal id As Integer)
        Using mConnection As New SqlConnection(Config.ConnectionString)
            Dim mCommand As SqlCommand = New SqlCommand("sprocQuestionDeleteSingleItem", mConnection)
            mCommand.CommandType = CommandType.StoredProcedure
            mCommand.Parameters.AddWithValue("@id", id)
            mConnection.Open()
            mCommand.ExecuteNonQuery()
            mConnection.Close()
        End Using
    End Sub



    ''' <summary>
    ''' Zapisuje odpowied na pytanie w nkiecie.
    ''' </summary>
    Public Shared Function SaveResponses() As Boolean

        Using mConnection As New SqlConnection(Config.ConnectionString)

            ' pobierz kontekst zapytania...(moemy tutaj uzyska dostp do wartoci 
            'z formularza, ktry wysa ostatnio uytkownik!)
            Dim mform As HttpContext = HttpContext.Current

            'pobierz z bazy danych list pyta
            Dim QuestionIDs As Collection = GetQuestionIDsForSurvey(mform.Request.QueryString("surveyID"))

            'przejd kolejno po kadym identyfikatorze pytania i dodaj odpowiedni odpowied
            'do tabeli 'responses'
            For i As Integer = 0 To QuestionIDs.Count - 1

                'upewnij si, e uytkownik wybra jeden z przyciskw opcji dla tego konkretnego identyfikatora pytania
                If mform.Request.Form.Item("Q" & QuestionIDs(i + 1).ToString()) <> "" Then

                    'Utwrz obiekt komendy
                    Dim mCommand As SqlCommand = New SqlCommand("sprocResponseInsertItem", mConnection)

                    'przypisz mu typ 'procedura skadowana'
                    mCommand.CommandType = CommandType.StoredProcedure

                    'daodaj dwa parametry: identyfikator pytania oraz wybr uytkownika (A,B,C lub D)
                    mCommand.Parameters.AddWithValue("@questionID", QuestionIDs(i + 1).ToString())
                    mCommand.Parameters.AddWithValue("@selection", mform.Request.Form.Item("Q" & QuestionIDs(i + 1).ToString()))

                    'otwrz poczenie i wykonaj procedur skadowan
                    mConnection.Open()
                    mCommand.ExecuteNonQuery()

                    'zamknij poczenie i pozbd si obiektu komendy
                    mConnection.Close()
                    mCommand.Dispose()

                End If
            Next

            Return True

        End Using


    End Function



    ''' <summary>
    ''' Zapisuje w bazie danych pytanie do ankiety
    ''' </summary>
    Public Shared Function SaveQuestion(ByVal surveyID As Integer, ByVal text As String, ByVal a As String, ByVal b As String, ByVal c As String, ByVal d As String, Optional ByVal ID As Integer = Nothing) As Boolean

        Using mConnection As New SqlConnection(Config.ConnectionString)

            'Utwrz obiekt komendy
            Dim mCommand As SqlCommand = New SqlCommand("sprocQuestionInsertUpdateItem", mConnection)

            'przypisz mu typ 'procedura skadowana'
            mCommand.CommandType = CommandType.StoredProcedure

            'dodaj parametry: identyfikator ankiety, tekst pytania, i moliwe odpowiedzi (A,B,C lub D)
            If ID > 0 Then
                mCommand.Parameters.AddWithValue("@id", ID)
            Else
                mCommand.Parameters.AddWithValue("@id", DBNull.Value)
            End If
            mCommand.Parameters.AddWithValue("@SurveyID", surveyID)
            mCommand.Parameters.AddWithValue("@Text", text)
            mCommand.Parameters.AddWithValue("@A", a)
            mCommand.Parameters.AddWithValue("@B", b)
            mCommand.Parameters.AddWithValue("@C", c)
            mCommand.Parameters.AddWithValue("@D", d)

            'otwrz poczenie i wykonaj procedur skadowan
            mConnection.Open()
            mCommand.ExecuteNonQuery()

            'zamknij poczenie i pozbd si obiektu komendy
            mConnection.Close()
            mCommand.Dispose()

            Return True

        End Using


    End Function
End Class
